jQuery(document).ready(function($) {
  var form = $('#edit-note');

  $('.add-note').click(function() {
    var note = $('<div class="note">i</div>');

    $('.container').prepend(note);

    note
      .draggable({
        stack: ".note",
        start: dragStart,
        stop: dragStop
      })
      .data({
        id: 'i',
        title: '',
        text: '',
        x: 0,
        y: 0
      })
      .click(function() {
        appendForm($(this));
      });

  });

  form.click(function(e) {
    e.stopPropagation();
  });

  // save note data on form submit
  form.submit(function(e) {
    e.preventDefault();

    // append form to body before editing notes text
    // as the form is part of the note at this moment
    form.appendTo('body').hide();

    $('.note.active')
      .text($('#note-id').val())
      .data({
        id: $('#note-id').val(),
        x: $('#note-x').val(),
        y: $('#note-y').val(),
        title: $('#note-title').val(),
        text: $('#note-text').val()
      });
  });

  // display JSON code
  $('.show-code').click(function() {

    if ($(this).hasClass('active')) {
      $(this).text('Show Code');
      $('.json-code').hide();
    } else {
      $(this).text('Hide Code');
      $('.json-code')
        .text(generateJSON())
        .show();
    }

    $(this).toggleClass('active');
  });

  // update x and y values in form on note drag stop
  function dragStop(event, ui) {
    $('#note-x').val(ui.position.left);
    $('#note-y').val(ui.position.top);
  }

  // move form to the note on drag start
  function dragStart(event, ui) {
    appendForm(ui.helper);
  }

  // attach form to note for synced dragging and
  // update form fields to notes saved settings
  function appendForm(elem) {

    $('.note').removeClass('active');
    elem.addClass('active');

    $('#note-x').val(elem.position().left);
    $('#note-y').val(elem.position().top);
    $('#note-id').val(elem.data('id'));
    $('#note-title').val(elem.data('title'));
    $('#note-text').val(elem.data('text'));

    form.appendTo(elem).show();
  }

  function generateJSON() {
    var tab = '  ',
      code = '"notes": [\n';

    $('.note').each(function() {
      code +=   tab + '{\n';
      code +=   tab + tab + '"id":    "' + $(this).data('id')    + '",\n';
      if ($(this).data('title') !== '') {
        code += tab + tab + '"title": "' + $(this).data('title') + '",\n';
      }
      if ($(this).data('text') !== '') {
        code += tab + tab + '"text":  "' + $(this).data('text')  + '",\n';
      }
      code +=   tab + tab + '"x":     "' + $(this).data('x')     + 'px",\n';
      code +=   tab + tab + '"y":     "' + $(this).data('y')     + 'px"\n';
      code +=   tab + '},\n';
    });
    code += ']\n';

    return code;
  }

});





















