jQuery(document).ready(function($) {

  // load data --------------------------------------------------- //
  $.ajax({
    url: 'javascripts/data-latest.json',
    dataType: 'jsonp',
    error: function(jqXHR, textStatus, errorThrown) {
      $('h1').text('Status: '+textStatus+' '+errorThrown);
    },
    success: function(data) {
      success(data);
    },
    jsonp: 'callback',
    jsonpCallback: 'callback'
  });

  // process the data -------------------------------------------- //
  function success(data) {
    var anchor = 'bottom',
      offset = '20%',
      hash = '', li,
      hidden = false;

    // show/hide nav button
    $('.slides').append('<li class="hide">&#x2039;</li>');
    $('.hide').click(function() {
      if (hidden) {
        $(this).html('&#x2039;');
        $('.date, h1, .info, li:not(.active, .hide)').show();
        $('.slides').css('margin-top', '0');
      } else {
        $(this).html('&#x203A;');
        $('.date, h1, .info, li:not(.active, .hide)').hide();
        $('.slides').css('margin-top', '28px');
      }
      hidden = !hidden;
    });

    // set nav bar styles
    if (data.hasOwnProperty('color')) {
      $('h1, .info, .hide').css('color', data.color);
      $('.date').css('background-color', data.color);
      $('.slides').css('background-color', 'rgba( ' + hexToRgb(data.color) + ', .8)');
      var style = '<style>.lt-ie9 .slides{ background-color: ' + data.color + '}</style>';
      $('head').append(style);
    }

    if (data.hasOwnProperty('anchor')) {
      anchor = data.anchor;
    }
    if (data.hasOwnProperty('offset')) {
      offset = data.offset;
    }
    if (anchor === 'top') {
      $('.header').css({
        bottom: 'auto',
        top: offset
      });
    } else {
      $('.header').css({
        top: 'auto',
        bottom: offset
      });
    }

    // set page header
    if (data.hasOwnProperty('title')) {
      $('h1').text(data.title).css('min-width', '100px');
    }
    if (data.hasOwnProperty('date')) {
      $('.date').text(data.date);
    }

    // build the nav
    for (var i = data.slides.length - 1; i >= 0; i--){
      var text,
        slide = data.slides[i],
        rel = filenameToHash(slide.image);

      // if navLabel is not defined use image filename
      if (slide.hasOwnProperty('navLabel')) {
        text = slide.navLabel;
      } else {
        text = slide.image;
        text = filenameToLabel(text);
      }

      $('.slides').prepend('<li rel="' + rel + '">' + text + '</li>');

      // add section dividers
      if (slide.hasOwnProperty('sectionBreakBefore') && slide.sectionBreakBefore === 'true') {
        $('.slides').prepend('<li class="divider">|</li>');
      }
    }

    // show image and background on nav click
    $('.slides li[rel]').click(function() {
      var ind = $('.slides li[rel]').index(this),
        slide = data.slides[ind],
        img = slide.image,
        bgr, align, desc;

      // set active nav element
      $('.slides li').removeClass('active');
      $(this).addClass('active');

      // set background
      if (slide.hasOwnProperty('background')) {
        bgr = slide.background;
      } else {
        bgr = 'white';
      }

      // set image alignment
      if (slide.hasOwnProperty('imageAlign')) {
        align = slide.imageAlign;
      } else {
        align = 'center';
      }

      // set image and background
      $('.image img').attr('src', img);
      $('.image').css({
        background: bgr,
        textAlign: align
      });

      // set description text
      if (slide.hasOwnProperty('description')) {
        desc = slide.description;
        $('.info').text(desc);
      } else {
        $('.info').text('');
      }

      // parse notes
      $('.note').remove();
      if (slide.hasOwnProperty('notes')) {
        addNotes(slide.notes);
      }

      // set hash
      window.location.hash = $(this).attr('rel');
    });

    // read hash on page load
    hash = window.location.hash.substring(1);
    li = $('.slides li[rel="' + hash + '"]');

    // show the correct slide
    if (hash !== '' && li.length) {
      li.click();

    // show the first slide on page load
    } else {
      $('.slides li:eq(0)').click();
    }

  }

  // image file name to label
  function filenameToLabel(filename) {
    filename = filename
                .substring(0, filename.indexOf('.'))
                .substring(filename.lastIndexOf('/') + 1, filename.length)
                .replace(/-|_/g, ' ');

    filename = filename.charAt(0).toUpperCase() + filename.slice(1);

    return filename;
  }

  // image file name to hash
  function filenameToHash(filename) {
    filename = filename
                .substring(0, filename.indexOf('.'))
                .substring(filename.lastIndexOf('/') + 1, filename.length)
                .replace(/ /g, '-')
                .toLowerCase();

    return filename;
  }

  function hexToRgb(hex) {
      // Expand shorthand form (e.g. "03F") to full form (e.g. "0033FF")
      var shorthandRegex = /^#?([a-f\d])([a-f\d])([a-f\d])$/i;
      hex = hex.replace(shorthandRegex, function(m, r, g, b) {
          return r + r + g + g + b + b;
      });

      var result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
      return parseInt(result[1], 16) + ", " + parseInt(result[2], 16) + ", " + parseInt(result[3], 16);
  }

  function addNotes(notes) {
    var i;
    for (i = notes.length - 1; i >= 0; i--){
      var note = $('<div class="note">i</div>');
      $('.container').prepend(note);
      note
        .text(notes[i].id)
        .css({
          top: notes[i].y,
          left: notes[i].x
        })
        .data({
          title: notes[i].title,
          text: notes[i].text
        });
    }
    $('.note').click(function() {
    });
  }

});
